/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.block.entity;

import dev.latvian.mods.kubejs.block.BlockBuilder;
import dev.latvian.mods.kubejs.block.entity.BlockEntityAttachmentHolder;
import dev.latvian.mods.kubejs.block.entity.BlockEntityAttachmentType;
import dev.latvian.mods.kubejs.block.entity.BlockEntityCallback;
import dev.latvian.mods.kubejs.block.entity.BlockEntityEventCallback;
import dev.latvian.mods.kubejs.block.entity.BlockEntityJS;
import dev.latvian.mods.kubejs.block.entity.BlockEntityJSTicker;
import dev.latvian.mods.kubejs.core.ServerPlayerKJS;
import dev.latvian.mods.kubejs.platform.LevelPlatformHelper;
import dev.latvian.mods.kubejs.util.ConsoleJS;
import dev.latvian.mods.rhino.util.HideFromJS;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1856;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_5558;

public class BlockEntityInfo {
    public final transient BlockBuilder blockBuilder;
    public transient class_2591<?> entityType;
    public transient class_2487 initialData;
    public transient BlockEntityJSTicker serverTicker;
    public transient BlockEntityJSTicker clientTicker;
    public transient boolean sync;
    public transient List<BlockEntityAttachmentHolder> attachments;
    public transient Int2ObjectMap<BlockEntityEventCallback> eventHandlers;

    public BlockEntityInfo(BlockBuilder blockBuilder) {
        this.blockBuilder = blockBuilder;
        this.initialData = new class_2487();
        this.sync = false;
        this.attachments = new ArrayList<BlockEntityAttachmentHolder>(1);
        this.eventHandlers = new Int2ObjectArrayMap(0);
    }

    public void initialData(class_2487 data) {
        this.initialData = data;
    }

    public void serverTick(int frequency, int offset, BlockEntityCallback callback) {
        this.serverTicker = new BlockEntityJSTicker(this, Math.max(1, frequency), Math.max(0, offset), callback, true);
    }

    public void serverTick(BlockEntityCallback callback) {
        this.serverTick(1, 0, callback);
    }

    public void clientTick(int frequency, int offset, BlockEntityCallback callback) {
        this.clientTicker = new BlockEntityJSTicker(this, Math.max(1, frequency), Math.max(0, offset), callback, false);
    }

    public void clientTick(BlockEntityCallback callback) {
        this.clientTick(1, 0, callback);
    }

    public void tick(int frequency, int offset, BlockEntityCallback callback) {
        this.serverTick(frequency, offset, callback);
        this.clientTick(frequency, offset, callback);
    }

    public void tick(BlockEntityCallback callback) {
        this.serverTick(callback);
        this.clientTick(callback);
    }

    public void enableSync() {
        this.sync = true;
    }

    public void attach(String type, Map<String, Object> args) {
        BlockEntityAttachmentType att = BlockEntityAttachmentType.ALL.get().get(type);
        if (att != null) {
            try {
                this.attachments.add(new BlockEntityAttachmentHolder(this.attachments.size(), att.factory().apply(args)));
            }
            catch (Exception ex) {
                ConsoleJS.STARTUP.error("Error while creating BlockEntity attachment '" + type + "'", ex);
            }
        } else {
            ConsoleJS.STARTUP.error("BlockEntity attachment '" + type + "' not found!");
        }
    }

    public void inventory(int width, int height) {
        this.attach("inventory", Map.of("width", width, "height", height));
    }

    public void inventory(int width, int height, class_1856 inputFilter) {
        this.attach("inventory", Map.of("width", width, "height", height, "inputFilter", inputFilter));
    }

    public void eventHandler(int eventId, BlockEntityEventCallback callback) {
        this.eventHandlers.put(eventId, (Object)callback);
    }

    public void rightClickOpensInventory() {
        this.blockBuilder.rightClick = e -> {
            class_2586 patt3545$temp = e.getBlock().getEntity();
            if (patt3545$temp instanceof BlockEntityJS) {
                BlockEntityJS entity = (BlockEntityJS)patt3545$temp;
                if (entity.inventory != null) {
                    ((ServerPlayerKJS)e.getPlayer()).kjs$openInventoryGUI(entity.inventory, (class_2561)((class_2248)this.blockBuilder.get()).method_9518());
                }
            }
        };
    }

    @HideFromJS
    public class_2586 createBlockEntity(class_2338 pos, class_2680 state) {
        return LevelPlatformHelper.get().createBlockEntity(pos, state, this);
    }

    @HideFromJS
    public <T extends class_2586> class_5558<T> getTicker(class_1937 level) {
        return level.method_8608() ? this.clientTicker : this.serverTicker;
    }

    public String toString() {
        return "BlockEntityInfo[" + this.blockBuilder.id + "]";
    }
}

